minetest.register_craftitem("lifesteal_mod:heart", {
		description = "1 Heart as an item.",
		inventory_image = "heart.png",
		on_use = function(itemstack, user, pointed_thing)
			local meta = user:get_meta()
			local health = meta:get_int("health")
			local health = health + 2
			meta:set_int("health", health)
			local inv = user:get_inventory()
			itemstack:take_item()
			user:set_properties({
					hp_max = health
			})
			return itemstack
		end
})

function on_punchplayer(player, hitter, _time_from_last_punch, _tool_capabilities, _dir, damage)
	if player:get_hp() > 0 and player:get_hp() - damage <= 0 and minetest.is_player(hitter) == true then
		local inv = hitter:get_inventory()
		if inv:room_for_item("main", {name = "lifesteal_mod:heart"}) then
			inv:add_item("main", "lifesteal_mod:heart")
		else
			minetest.add_item(hitter:get_pos(), {name = "lifesteal_mod:heart"})
		end
	end
end